var upload_count_flag = "feedback_count_v1";
var local_count_flag = "count";
var local_version_flag = "version_flag_v1";
//隨機ID
function makeid(length) {
	var result = '';
	var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
	var charactersLength = characters.length;
	for ( var i = 0; i < length; i++ ) {
		result += characters.charAt(Math.floor(Math.random() * charactersLength));
	}
	return result;
}
//設定
var local = (function(){
	var setData = function(key,obj){
		var values = JSON.stringify(obj);
		localStorage.setItem(key,values);
	}
	var getData = function(key){
		if(localStorage.getItem(key) != null){
			return JSON.parse(localStorage.getItem(key));
		}else{
			return false;
		}
	}
	var updateDate = function(key,newData){
		if(localStorage.getItem(key) != null){
			var oldData = JSON.parse(localStorage.getItem(key));
			for(keyObj in newData){
				oldData[keyObj] = newData[keyObj];
			}
			var values = JSON.stringify(oldData);
			localStorage.setItem(key,values);
		}else{
			return false;
		}
	}
	return {
		set: setData,
		get: getData,
		update: updateDate
	}
})();
//下載、套用
var ref = (function(){
	var upcount = function(){
		local.set(local_version_flag, chrome.runtime.getManifest().version);
		//產生隨機ID
		if(!local.get('hash')){
			local.set('hash', makeid(32));
		}
		var hash = local.get('hash');
		//上傳
		console.log("上傳次數->");
		//上傳次數
		if(!local.get(upload_count_flag) && local.get(local_count_flag)){
			//第一次執行
			console.log("第一次上傳次數");
			var dt = new Date();
			var xhr = new XMLHttpRequest();
			xhr.open("GET", "https://killad.cumi.co/count.php?count="+local.get(local_count_flag)+"&ver="+chrome.runtime.getManifest().version+"&hash="+hash, true);
			xhr.onreadystatechange = function() {
				if (xhr.readyState == 4) {
					console.log( dt + ' - 上傳成功，統計次數(' + local.get(local_count_flag) + ').' );
					//上傳成功才儲存
					local.set(upload_count_flag, local.get(local_count_flag));
				}
			}
			xhr.send();
		}else{
			//載入上次次數
			var now_feedback_count = local.get(local_count_flag) - local.get(upload_count_flag);
			console.log("upload count = ", now_feedback_count);
			if(now_feedback_count > 0){
				var dt = new Date();
				var xhr = new XMLHttpRequest();
				xhr.open("GET", "https://killad.cumi.co/count.php?count="+now_feedback_count+"&ver="+chrome.runtime.getManifest().version+"&hash="+hash, true);
				xhr.onreadystatechange = function() {
					if (xhr.readyState == 4) {
						console.log( dt + ' - 上傳成功，統計次數(' + now_feedback_count + ').' );
						//上傳成功才儲存
						local.set(upload_count_flag, local.get(local_count_flag));
					}
				}
				xhr.send();
			}
		}
	}
	var upd = function(){
		local.set(local_version_flag, chrome.runtime.getManifest().version);
		console.log("列表更新->");
		var dt = new Date();
		//block host
		var xhr = new XMLHttpRequest();
		xhr.open("GET", "https://killad.cumi.co/sync.json?" + dt, true);
		xhr.onreadystatechange = function() {
			if (xhr.readyState == 4) {
				var block_list = JSON.parse(xhr.responseText);
				local.set('block', block_list.data);
				console.log( dt + ' - 惡意網站列表 - 同步成功(' + block_list.data.length + ').' );
			}
		}
		xhr.send();
		//block popup
		var xhr_pop = new XMLHttpRequest();
		xhr_pop.open("GET", "https://killad.cumi.co/pop_sync.json?" + dt, true);
		xhr_pop.onreadystatechange = function() {
			if (xhr_pop.readyState == 4) {
				var pop_list = JSON.parse(xhr_pop.responseText);
				local.set('pop', pop_list.data);
				chrome.storage.local.set({'pop': pop_list.data}, function() {  });
				console.log( dt + ' - 彈跳視窗列表 - 同步成功(' + pop_list.data.length + ').' );
			}
		}
		xhr_pop.send();
	}
	var use = function(){
		local.set(local_version_flag, chrome.runtime.getManifest().version);
		console.log("列表套用->");
		if(local.get('block')){
			chrome.runtime.onMessage.addListener((request, sender, response) => {
				try{
					//popup攔截
					var dtn = new Date();
					if(request.btype == 'test_dump') {
						console.log( dtn + ' - ['+sender.tab.id+']', request.dump);
					}
					if(request.btype == 'popup_blank') {
						console.log( dtn + ' - ['+sender.tab.id+']popup封鎖('+request.opener+')  window.open about:blank.' );
					}
					if(request.btype == 'popup_ads') {
						console.log( dtn + ' - ['+sender.tab.id+']popup封鎖('+request.opener+')  window.open ('+request.popup+').' );
					}
					if(request.btype == 'skip_ad') {
						console.log( dtn + ' - ['+sender.tab.id+']跳過廣告('+request.opener+')' );
					}
					if(request.btype == 'close_ad') {
						console.log( dtn + ' - ['+sender.tab.id+']關閉廣告('+request.opener+')' );
					}
					//統計攔截次數
					var count = 0;
					if(!local.get(local_count_flag)){
						local.set(local_count_flag, 0);
					}else{
						count = local.get(local_count_flag);
					}
					count++;
					local.set(local_count_flag, count);
				}catch (e){
					
				}
			});
			chrome.webRequest.onBeforeRequest.addListener(
				function(requestDetails){
					
					var dtn = new Date();
					//console.log(chrome.tabs);
					//console.log(' %%%%%%%%%% - ', requestDetails.type + ', url=' + requestDetails.url);
					//統計攔截次數
					var count = 0;
					if(!local.get(local_count_flag)){
						local.set(local_count_flag, 0);
					}else{
						count = local.get(local_count_flag);
					}
					count++;
					local.set(local_count_flag, count);
					//紀錄
					if(requestDetails.type == 'main_frame'){
						console.log("main_frame", requestDetails);
						console.log("關閉來自 " + requestDetails.initiator);
						try{
							chrome.tabs.remove(requestDetails.tabId, null);	//關閉視窗
						}catch (e){
							
						}
						console.log( dtn + ' - ['+requestDetails.tabId+']網站被拒絕連線並且關閉(' + requestDetails.url + '), 來自(' + requestDetails.initiator + ')' );
					}
					if(requestDetails.type == 'script'){
						//console.log( dtn + ' - 程式碼被拒絕載入[' + requestDetails.url + '], 來自(' + requestDetails.initiator + ')' );
					}
					if(requestDetails.type == 'image'){
						//console.log( dtn + ' - 圖片被拒絕載入[' + requestDetails.url + ']' );
					}
					return {cancel: true};
				},
				{
					urls: local.get('block')
				},
				["blocking"]
			);
		}
	}
	return {
		upd: upd,
		use: use,
		upcount: upcount
	}
})();
			
//更新並套用
setTimeout(function(){ ref.upd(); }, 0);
setTimeout(function(){ ref.use(); }, 2000);
setTimeout(function(){ ref.upcount(); }, 5000);
setInterval(function(){ ref.upcount(); }, 1800000);
//套用listen
chrome.runtime.onMessage.addListener(
	function(request, sender, sendResponse) {
		if (request.msg === "refrush") {
			location.reload();
		}
	}
);
