'use strict';

//設定
var b_hostname = location.href;;
var b_opentype = "";

const _prefs = { // Firefox issue
	'enabled': true,
	'shadow': false,
	'domain': false,
	'protocols': ['magnet:'],
	'popup-hosts': null,
	'block-page-redirection': false
};

chrome.storage.local.get('pop', function (result) {
	//讀取popup
	_prefs['popup-hosts'] = result.pop;
	for (const h of _prefs['popup-hosts']) {
		if (b_hostname.match(h)) {
			//名單內才鎖定，其他正常跳
			init();
			break;
		}
	}
});

function init() {
	console.log("start popup blocker");
	if (document.contentType === 'text/html') {

		const script = document.createElement('script');
		// record fake window's executed commands
		const records = {};
		
		const prefs = new Proxy(_prefs, {
			set(obj, key, value) {
				obj[key] = value;
				// allow the unprotected code to get relevant preferences
				if (key === 'enabled' || key === 'shadow') {
					script.dataset[key] = value;
				}
				return true;
			}
		});
		// make sure we have access to our preferences from the same origin iframes
		window.prefs = prefs;

		// try to get the preferences from the top element; otherwise get them from chrome.storage
		{
			let loaded = false;
			if (window.parent !== window) {
				// console.log(window.parent.prefs, self.parent.prefs, this.parent.prefs, parent.prefs);
				try {
					if (window.parent.prefs !== undefined) { // Firefox issue
						Object.assign(prefs, window.parent.prefs);
						loaded = true;
					}
				}
				catch (e) {}
			}
			if (loaded === false) {
				chrome.storage.local.get(_prefs, ps => {
					Object.assign(prefs, ps);
					if (prefs.enabled) {
						/*
						chrome.runtime.sendMessage({
							cmd: 'exception',
							href: location.href,
							hostname: location.hostname,
							top: window.top === window // Edge does not support sender.frameId === 0
						}, response => {
							prefs.enabled = true;
							b_hostname = location.href;
							//console.log("第一個", location);
						});
						*/
					}
				});
			}
		}

		script.textContent = `{
			// definitions
			const script = document.currentScript;
			const blocker = {};
			// pointers
			const pointers = {
				'mpp': MouseEvent.prototype.preventDefault,
				'hac': HTMLAnchorElement.prototype.click,
				'had': HTMLAnchorElement.prototype.dispatchEvent,
				'hfs': HTMLFormElement.prototype.submit,
				'hfd': HTMLFormElement.prototype.dispatchEvent,
				'wop': window.open
			};
			// helper functions
			const policy = (type, element, event, extra = {}) => {
				if (event) {
					extra.defaultPrevented = event.defaultPrevented;
					extra.metaKey = event.metaKey;
					extra.button = event.button || 0;
					extra.isTrusted = event.isTrusted;
				}
				script.dispatchEvent(new CustomEvent('policy', {
					detail: Object.assign({
						type,
						href: element.action || element.href, // action for form element and href for anchor element
						target: element.target
					}, extra)
				}));
				return {
					id: script.getAttribute('eid'),
					block: script.getAttribute('block') === 'true'
				};
			};
			const watch = (parent, name, callback) => {
				let original = parent[name];
				Object.defineProperty(parent, name, {
					configurable: true,
					get() {
						callback();
						return original;
					},
					set(v) {
						original = v;
					}
				});
			};
			const simulate = (name, root, id) => new Proxy({}, { // window.location.replace
				get(obj, key) {
					return typeof root[key] === 'function' ? function(...args) {
						script.dispatchEvent(new CustomEvent('record', {
							detail: {
								id,
								name,
								method: root[key].name || key, // window.focus
								args
							}
						}));
					} : simulate(key, root[key], id);
				}
			});
			// popup blocker
			blocker.install = () => {
				document.addEventListener('click', blocker.overwrite.click, true); // with capture; see method 8
				window.open = blocker.overwrite.open;
				HTMLAnchorElement.prototype.click = blocker.overwrite.a.click;
				HTMLAnchorElement.prototype.dispatchEvent = blocker.overwrite.a.dispatchEvent;
				HTMLFormElement.prototype.submit = blocker.overwrite.form.submit;
				HTMLFormElement.prototype.dispatchEvent = blocker.overwrite.form.dispatchEvent;
			};
			blocker.remove = () => {
				document.removeEventListener('click', blocker.overwrite.click);
				window.open = pointers.wop;
				HTMLAnchorElement.prototype.click = pointers.hac;
				HTMLAnchorElement.prototype.dispatchEvent = pointers.had;
				HTMLFormElement.prototype.submit = pointers.hfs;
				HTMLFormElement.prototype.dispatchEvent = pointers.hfd;
			};

			blocker.overwrite = {};
			blocker.overwrite.click = e => {
				const a = e.target.closest('[target]') || e.target.closest('a');
				// if this is not a form or anchor element, ignore the click
				if (a && policy('element.click', a, e).block) {
					pointers.mpp.apply(e);
					return true;
				}
			};
			blocker.overwrite.a = {};
			blocker.overwrite.a.click = function(...args) {
				const {block} = policy('dynamic.a.click', this);
				if (!block) {
					pointers.hac.apply(this, args);
				}
			};
			blocker.overwrite.a.dispatchEvent = function(...args) {
				const e = args[0];
				let {block} = policy('dynamic.a.dispatch', this, e);
				return block ? false : pointers.had.apply(this, args);
			};
			blocker.overwrite.form = {};
			blocker.overwrite.form.submit = function(...args) {
				const {block} = policy('dynamic.form.submit', this);
				return block ? false : pointers.hfs.apply(this, args);
			};
			blocker.overwrite.form.dispatchEvent = function(...args) {
				const {block} = policy('dynamic.form.dispatch', this);
				return block ? false : pointers.hfd.apply(this, args);
			};
			blocker.overwrite.open = function(...args) {
				const {id, block} = policy('window.open', {
					href: args.length ? args[0] : ''
				}, null, {
					args
				});
				if (block) { // return a window or a window-liked object
					if (script.dataset.shadow === 'true') {
						const iframe = document.createElement('iframe');
						iframe.style.display = 'none';
						document.body.appendChild(iframe);
						return iframe.contentWindow;
					}
					else {
						return simulate('self', window, id);
					}
				}
				else {
					return pointers.wop.apply(window, args);
				}
			};
			// we always install our blocker
			blocker.install();
			// document.open can wipe all the listeners
			let documentElement = document.documentElement;
			watch(document, 'write', () => {
				if (documentElement !== document.documentElement) {
					documentElement = document.documentElement;
					if (script.dataset.enabled !== 'false') {
						blocker.install();
					}
				}
			});
			// configure
			new MutationObserver(() => blocker[script.dataset.enabled === 'false' ? 'remove' : 'install']()).observe(script, {
				attributes: true,
				attributeFilter: ['data-enabled']
			});
		}`;
		(document.head || document.documentElement).appendChild(script);
		script.remove();

		const blocker = {};
		blocker.policy = request => {
			const target = document.activeElement;
			const {type} = request;
			let href = request.href;
			let hostname = '';
			let block = true;
			let sameContext = false;
			
			if (type === 'element.click') {
				const a = 'closest' in target ? (target.closest('[target]') || target.closest('a')) : null;
				href = href || (a ? a.href || a.action : '');
				// we are blocking either if a is found or href is provided; see method 12/4
				block = Boolean(a) || href;
			}
			
			// always run window open on the same context
			if (type === 'window.open') {
				sameContext = true;
			}
			// block if
			if (request.metaKey && request.isTrusted === false) { // see method 12/5
				block = true;
			}
			if ('button' in request && request.button !== 0 && request.isTrusted === false) { // see method 12/2
				block = true;
			}
			// do not block if
			if (request.defaultPrevented || (request.metaKey && request.isTrusted)) {
				block = false;
			}
			// fixing
			if (true) {
				// fix relative href
				if (href && href.indexOf(':') === -1) {
					const a = document.createElement('a');
					a.setAttribute('href', href);
					href = a.href;
				}
				// create a unique id when "href" is not usable
				if (!href || href.startsWith('about:blank')) {
					target.dataset.ppbid = target.dataset.ppbid || Math.random();
				}
				if (href) {
					try {
						const loc = new URL(href);
						b_opentype = loc.href;
						// white-list matching
						block = false;
						if (b_hostname) {
							var pop_hosts = _prefs['popup-hosts'];
							if(pop_hosts){
								for (const h of pop_hosts) {
									if (b_hostname.match(h)) {
										block = true;
										chrome.runtime.sendMessage({opener: b_hostname, btype: 'popup_blank'}, null);
										break;
									}
								}
							}
						}
					} catch (e) {}
				}
			}

			const id = target.dataset.ppbid || Math.random();
			
			if(!href) {
				href = 'about:blank';
			}
			
			if(b_opentype != 'about:blank'){
				block = false;
			}
			//console.log(request);
			if(request.type == 'window.open' && request.href == ""){
				//開空白頁面
				block = true;
				href = 'about:blank';
				chrome.runtime.sendMessage({opener: b_hostname, btype: 'popup_blank'}, null);
				//console.log(request.href);
				
			}
			
			return {
				id,
				href,
				hostname,
				sameContext,
				block
			};
		};
		// channel
		script.addEventListener('policy', e => {
			// make sure the request is from our script; see example 1
			if (e.target === script) {
				if (prefs.enabled) {
					const request = e.detail;
					const {block, id, href, hostname} = blocker.policy(request);
					script.setAttribute('eid', id);
					script.setAttribute('block', block);
				} else {
					script.setAttribute('block', false);
				}
			}
		});
	}
}